/*

Copyright (c) 2004 PXI Project Team

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the "Software"), to deal in the
Software without restriction, including without limitation the rights to use,
copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the
Software, and to permit persons to whom the Software is furnished to do so,
subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies
or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

#ifndef _____CUTE_TOKENIZER_____
#define _____CUTE_TOKENIZER_____

#include <vector>
#include <string>
using namespace std;

class cuteTokenizer
{
public:
										cuteTokenizer					( void );
										cuteTokenizer					( const string &, char );

										~cuteTokenizer					( void );

const		cuteTokenizer &				operator=						( const cuteTokenizer & );

			string						fetch_token						( int );
			string						fetch_token						( int, int );

			void						tokenize						( const string &, char );
			void						tokenize						( const string & );

			void						hc_tokenize						( const string &, const string& );

			void						setDelim						( char );
			char						getDelim						( void );
			
			int							numtokens						( void ) { return ( ( int ) tokens.size() ); };
			
			bool						add_spaces;

private:
			void						split_chars						( const string & );
			void						split_lines						( const string & );
			void						split_words						( const string & );
			void						split_items						( const string & );

			vector < string >			tokens;
			string						char_string;
			string						internals;
			char						delim;
			bool						char_mode;
};

#endif
